/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.former;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.reccomplex..shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.NaP;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex..shadow.mcopts.commands.parameters.expect.MCE;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.capability.SelectionOwner;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.commands.parameters.IvP;
import ivorius.reccomplex.commands.parameters.RCP;
import ivorius.reccomplex.operation.OperationClearArea;
import ivorius.reccomplex.operation.OperationGenerateStructure;
import ivorius.reccomplex.operation.OperationMulti;
import ivorius.reccomplex.operation.OperationRegistry;
import ivorius.reccomplex.utils.RCBlockAreas;
import ivorius.reccomplex.world.gen.feature.StructureGenerator;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class CommandSelectMove
extends CommandExpecting {
    public String func_71517_b() {
        return RCConfig.commandPrefix + "move";
    }

    @Override
    public void expect(Expect expect) {
        expect.then(MCE.pos("x", "y", "z")).named("rotation", "r").then(MCE::rotation).flag("mirror", "m").flag("noselect", "s").flag("duplicate", "c").named("times", "t").any(1, 2, 3);
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        SelectionOwner selectionOwner = RCCommands.getSelectionOwner(commandSender, null, true);
        RCCommands.assertSize(commandSender, selectionOwner);
        BlockPos move = (BlockPos)parameters.get(RCP.pos("x", "y", "z", BlockPos.field_177992_a, false)).require();
        AxisAlignedTransform2D transform = parameters.get(IvP.transform("rotation", "mirror")).optional().orElse(AxisAlignedTransform2D.ORIGINAL);
        boolean noselect = parameters.has("noselect");
        boolean duplicate = parameters.has("duplicate");
        int times = parameters.get("times").to(NaP::asInt).optional().orElse(1);
        BlockArea area = selectionOwner.getSelection();
        IvWorldData worldData = IvWorldData.capture((World)commandSender.func_130014_f_(), (BlockArea)area, (boolean)true);
        NBTTagCompound worldDataCompound = worldData.createTagCompound();
        GenericStructure structure = GenericStructure.createDefaultStructure();
        structure.worldDataCompound = worldDataCompound;
        BlockPos pos = selectionOwner.getSelection().getLowerCorner();
        for (int i = 0; i < times; ++i) {
            pos = pos.func_177971_a((Vec3i)move);
            if (duplicate) {
                OperationRegistry.queueOperation(new OperationGenerateStructure(structure, null, transform, pos, true).prepare((WorldServer)commandSender.func_130014_f_()), commandSender);
                continue;
            }
            OperationRegistry.queueOperation(new OperationMulti(new OperationClearArea(area), new OperationGenerateStructure(structure, null, transform, pos, true).prepare((WorldServer)commandSender.func_130014_f_())), commandSender);
        }
        if (!noselect) {
            StructureGenerator<GenericStructure.InstanceData> generator = new StructureGenerator<GenericStructure.InstanceData>(structure).transform(transform).lowerCoord(pos);
            StructureBoundingBox boundingBox = generator.boundingBox().get();
            selectionOwner.setSelection(RCBlockAreas.from(boundingBox));
        }
    }
}

